---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：17-Streaming Query Statistics（ストリーミングクエリ統計）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **カスタムメトリクス設定のデフォルト値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryStatisticsPage.scala` 行37-565
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryTab.scala` 行23-42
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` No.17
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` No.17
- E-05: `docs/code-to-docs/画面遷移図.md` StreamingQueryTab

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは/StreamingQuery/statistics/ | E-01 行38: WebUIPage("statistics") | ○ |
| C-02 | idパラメータ（Run ID）が必須 | E-01 行60-61: パラメータ取得とrequire | ○ |
| C-03 | Run IDでクエリ検索 | E-01 行63-65: allQueryUIData.find | ○ |
| C-04 | 基本情報にDuration/Start Time/Batches/Name/Id/RunId表示 | E-01 行114-143: generateBasicInfo | ○ |
| C-05 | Input Rateグラフ（records/sec） | E-01 行434-443, 507-511 | ○ |
| C-06 | Process Rateグラフ（records/sec） | E-01 行446-455, 513-520 | ○ |
| C-07 | Input Rowsグラフ（records） | E-01 行458-467, 522-529 | ○ |
| C-08 | Batch Durationグラフ（ms） | E-01 行470-479, 531-538 | ○ |
| C-09 | Operation Durationスタック面グラフ | E-01 行482-491, 540-546 | ○ |
| C-10 | triggerExecutionを除外 | E-01 行428: durationMs.remove("triggerExecution") | ○ |
| C-11 | Watermark Gapグラフ（seconds） | E-01 行146-196: generateWatermark | ○ |
| C-12 | Watermark Gapは(batchTimestamp - watermarkValue)/1000.0 | E-01 行159: (batchTimestamp - watermarkValue) / 1000.0 | ○ |
| C-13 | Aggregated State Operatorメトリクス5種 | E-01 行198-334: Total/Updated/Removed/Memory/DroppedByWatermark | ○ |
| C-14 | カスタムメトリクス表示 | E-01 行345-388: generateAggregatedCustomMetrics | ○ |
| C-15 | StateStoreProviderのsupportedCustomMetrics使用 | E-01 行42-43 | ○ |
| C-16 | D3.js使用 | E-01 行52 | ○ |
| C-17 | streaming-page.js/css使用 | E-01 行53-55 | ○ |
| C-18 | GraphUIDataでタイムライン・ヒストグラム生成 | E-01 行434等: new GraphUIData | ○ |
| C-19 | 進捗データなし時のメッセージ | E-01 行553-555: "No visualization information available." | ○ |
| C-20 | ENABLED_STREAMING_UI_CUSTOM_METRIC_LISTのデフォルト値 | **根拠なし（StaticSQLConf要確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- ENABLED_STREAMING_UI_CUSTOM_METRIC_LIST設定のデフォルト値はStaticSQLConf定義を確認する必要がある
  - 候補：`sql/catalyst/src/main/scala/org/apache/spark/sql/internal/StaticSQLConf.scala`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なグラフ表示仕様はソースコードと一致
- 1: 中リスク - カスタムメトリクスの表示条件（設定値）を確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] ENABLED_STREAMING_UI_CUSTOM_METRIC_LISTのデフォルト値を確認
- [ ] D3.jsグラフの描画が大量バッチデータでも正常か確認
- [ ] StateStoreProviderのsupportedCustomMetricsが実装固有であることの注意書きが適切か確認
